###############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_putty_version.nasl 1020 2009-06-01 20:05:29Z Feb $
#
# Ptty Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900618);
  script_version ("$Revision: 1.2 $");
  script_name("putty Version Detection");
  desc = "
  Overview: This script determines the putty version on
  the remote host and sets the result in the KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Sets KB of puTTY version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod.");
  script_family("Service detection");
  script_dependencie("find_service.nes", "secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

path = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\PuTTY_is1",item:"DisplayName");

if(!path){
  exit(0);
}

version = eregmatch(pattern:"[0-9.]+", string:path);
if(version){
  set_kb_item(name:"PuTTY/Version", value:version[0]);
}
