###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_sec_bypass_vuln_aug09.nasl 4136 2009-08-28 21:30:29Z aug $
#
# PHP Security Bypass Vulnerability - Aug09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900835);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7002");
  script_bugtraq_id(31064);
  script_name("PHP Security Bypass Vulnerability - Aug09");
  desc = "
  Overview:
  This host is running PHP and is prone to Security Bypas vulnerability.

  Vulnerability Insight:
  Error exists when application fails to enforce 'safe_mode_exec_dir' and
  'open_basedir' restrictions for certain functions, which can be caused via
  the exec, system, shell_exec, passthru, or popen functions, possibly
  involving pathnames such as 'C:' drive notation.

  Impact:
  Successful exploitation will let the local attacker execute arbitrary code and
  can bypass security restriction in the context of the web application.

  Impact Level: Application

  Affected Software/OS:
  PHP version 5.2.5

  Fix: No solution or patch is available as on 28th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.php.net/

  References:
  http://en.securitylab.ru/nvd/383831.php
  http://downloads.securityfocus.com/vulnerabilities/exploits/31064.php

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort)
{
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!isnull(phpVer))
{
  # Check for PHP version 5.2.5
  if(version_is_equal(version:phpVer, test_version:"5.2.5")){
    security_hole(phpPort);
  }
}
