###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_mbstring_ext_bof_vuln.nasl 767 2008-12-29 11:03:24Z dec $
#
# Heap-based buffer overflow in 'mbstring' extension for PHP
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900185);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5557");
  script_bugtraq_id(32948);
  script_name("Heap-based buffer overflow in 'mbstring' extension for PHP");
  desc = "

  Overview: The host is running PHP and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in mbfilter_htmlent.c file in the mbstring
  extension. These can be exploited via mb_convert_encoding, mb_check_encoding,
  mb_convert_variables, and mb_parse_str functions.

  Impact:
  Successful exploitation could allow attackers to execute arbitrary code via
  a crafted string containing an HTML entity.

  Impact Level: Application

  Affected Software/OS:
  PHP version 4.3.0 to 5.2.6 on all running platform.

  Fix: Upgrade to version 5.2.7 or later,
  http://www.php.net/downloads.php

  References:
  http://bugs.php.net/bug.php?id=45722
  http://archives.neohapsis.com/archives/fulldisclosure/2008-12/0477.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Buffer overflow");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Grep for version 4.3.0 to 5.2.6
if(version_in_range(version:phpVer, test_version:"4.3.0", test_version2:"5.2.6")){
  security_hole(phpPort);
}
