###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_imagerotate_info_disc_vuln.nasl 792 2008-12-29 18:00:24Z dec $
#
# PHP 'imageRotate()' Memory Information Disclosure Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900186);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5498");
  script_bugtraq_id(33002);
  script_name("PHP 'imageRotate()' Memory Information Disclosure Vulnerability");
  desc = "

  Overview: The host is running PHP and is prone to Memory Information
  Disclosure vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper validation of bgd_color or clrBack
  argument in imageRotate function.

  Impact:
  Successful exploitation could let the attacker read the contents of arbitrary
  memory locations through a crafted value for an indexed image.

  Impact Level: Application

  Affected Software/OS:
  PHP version 5.x to 5.2.8 on all running platform.

  Fix: No solution or patch is available as on 31st December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.php.net/

  References:
  http://securitytracker.com/alerts/2008/Dec/1021494.html
  http://downloads.securityfocus.com/vulnerabilities/exploits/33002.php
  http://downloads.securityfocus.com/vulnerabilities/exploits/33002-2.php

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 2.9
  Risk factor: Low";

  script_description(desc);
  script_summary("Check for the Version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Grep for version 5.0. to  5.2.8 
if(version_in_range(version:phpVer, test_version:"5.0", test_version2:"5.2.8")){
  security_warning(phpPort);
}
