###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_address_book_sql_inj_vuln.nasl 3684 2009-08-03 09:35:29Z Aug $
#
# PHP Address Book Multiple SQL Injection Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900698);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2608");
  script_bugtraq_id(35511);
  script_name("PHP Address Book Multiple SQL Injection Vulnerabilities");
  desc = "

  Overview: This host is running PHP Address Book and is prone to SQL Injection
  vulnerability.

  Vulnerability Insight:
  The flaw is due to improper sanitization of user supplied input passed to the
  'id' parameter in view.php, edit.php, and delete.php, and to the 'alphabet'
  parameter in index.php before being used in SQL queries.

  Impact:
  Successful exploitation will let the attacker cause SQL Injection attack, gain
  sensitive information about the database used by the web application.

  Impact Level: Application

  Affected Software/OS:
  PHP Address Book version 4.0.x

  Fix: No solution or patch is available as on 03rd August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/php-addressbook/

  References:
  http://secunia.com/advisories/35590
  http://www.milw0rm.com/exploits/9023

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of PHP-Nuke");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_php_address_book_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/"+ phpPort + "/PHP-Address-Book");
if(!phpVer){
  exit(0);
}

ver = eregmatch(pattern:"^(.+) under (/.*)$", string:phpVer);
if(ver[1] =~ "^4\.0"){
  security_hole(phpPort);
}
