###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_otrs_detect.nasl 7203 2010-02-19 12:20:36Z feb $
#
# Open Ticket Request System (OTRS) Version Detection
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902018);
  script_version("$Revision: 6804 $: 1.0");
  script_name("Open Ticket Request System (OTRS) Version Detection");
  desc = "
  Overview: This script finds the running Open Ticket Request System (OTRS)
  version and saves the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of Open Ticket Request System (OTRS) in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 SecPod");
  script_family("Service detection");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

otrsPort = get_http_port(default:80);
if(!otrsPort){
  otrsPort = 80;
}

if(!get_port_state(otrsPort)){
  exit(0);
}

foreach dir (make_list("/OTRS", "/otrs", cgi_dirs()))
{
  sndReq = http_get(item:string(dir , "/index.pl"), port:otrsPort);
  rcvRes = http_send_recv(port:otrsPort, data:sndReq, bodyonly:1);
  if("Welcome to OTRS" >< rcvRes)
  {
    otrsVer = eregmatch(pattern:"OTRS ([0-9.]+)" , string:rcvRes);
    if(otrsVer[1] != NULL){
      set_kb_item(name:"www/" + otrsPort + "/OTRS",
                                value:otrsVer[1] + " under " + dir);
    }
  }
}
