###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_opera_unicode_str_dos_vuln_win.nasl 3624 2009-07-23 18:29:29Z jul $
#
# Opera Unicode String Denial Of Service Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Updated for New CVE's
# - By Sharath S <sharaths@secpod.com> On 2009-09-21 #4893
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900803);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2009-2577", "CVE-2008-7245", "CVE-2009-3269");
  script_name("Opera Unicode String Denial Of Service Vulnerability (Win)");
  desc = "
  Overview: This host is installed with Opera and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  - Error caused by calling the 'window.print' function in a loop aka a
    'printing DoS attack'.
  - CPU consumption issue exists when a series of automatic submissions
    of a form containing a KEYGEN element.
  - Error exists when application fails to handle user supplied input into
    the 'write' method via a long Unicode string argument.

  Impact:
  Successful exploitation lets the attacker cause memory or CPU consumption,
  resulting in Denial of Service condition.

  Impact Level: Application

  Affected Software/OS:
  Opera version 9.52 and prior on Windows.

  Fix: No solution or patch is available as on 21st September 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.opera.com/

  References:
  http://websecurity.com.ua/3338/
  http://websecurity.com.ua/2456/
  http://websecurity.com.ua/3194/
  http://www.securityfocus.com/archive/1/archive/1/505092/100/0/threaded
  http://www.securityfocus.com/archive/1/archive/1/506328/100/100/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Opera");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Win/Version");
if(!operaVer){
  exit(0);
}

# Check for Opera version <= 9.52
if(version_is_less_equal(version:operaVer, test_version:"9.52")){
  security_warning(0);
}
