###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_opera_pdf_js_rest_bypass_vuln_win.nasl 2251 2009-05-14 14:47:50Z may $
#
# Opera PDF Javascript Security Bypass Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900635);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1599");
  script_name("Opera PDF Javascript Security Bypass Vulnerability (Win)");
  desc = "

  Overview: The host is installed with Opera Web Browser and is prone to PDF
  Javascript Security Bypass Vulnerability.

  Vulnerability Insight:
  An error in Adobe Acrobat JavaScript protocol handler in the context of browser
  when a PDF file is opened in it via execute DOM calls in response to a
  javascript: URI.

  Impact:
  Successful exploitation will let attacker to execute arbitrary code result in
  spoof URLs, bypass the security restriction, XSS, Memory corruption, phishing
  attacks and steal generic information from website.

  Impact level: Application/Network

  Affected Software/OS:
  Opera version 9.64 and prior on Windows.

  Fix: No solution or patch is available as on 18th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.opera.com/download

  References:
  http://www.securityfocus.com/archive/1/archive/1/503183/100/0/threaded
  http://secniche.org/papers/SNS_09_03_PDF_Silent_Form_Re_Purp_Attack.pdf

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Win/Version");
if(operaVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:operaVer, test_version:"9.64")){
  security_hole(0);
}
