###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_opera_info_disc_unspecified_vuln_lin.nasl 5900 2009-11-30 15:58:09Z nov $
#
# Opera Information Disclosure and Unspecified Vulnerabilities - (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900987);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-4071", "CVE-2009-4072");
  script_bugtraq_id(37089);
  script_name("Opera Information Disclosure and Unspecified Vulnerabilities - (Linux)");
  desc = "
  Overview: The host is installed with Opera Web Browser and is prone to
  Information Disclosure and other unspecified vulnerabilities.

  Vulnerability Insight:
  - Opera stores certain scripting error messages in variables which can be
    read by web sites which can be exploited to execute arbitrary HTML and
    script code in a user's browser session.
  - A vulnerability is caused due to an unspecified error.

  Impact:
  Successful exploitation will allow remote attackers to launch cross-site
  scripting attacks or potentially obtain sensitive information and second
  issue has an unknown, but moderate, impact.

  Impact Level: Application

  Affected Software/OS:
  Opera version prior to 10.10 on Linux.

  Fix: Upgrade to Opera 10.10
  http://www.opera.com/download/?custom=yes

  References:
  http://secunia.com/advisories/37469/
  http://www.opera.com/docs/changelogs/unix/1010/

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_opera_detection_linux_900037.nasl");
  script_require_keys("Opera/Linux/Version");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Linux/Version");
if(!operaVer){
  exit(0);
}

# Check if version is lesser than 10.10
if(version_is_less(version:operaVer, test_version:"10.10")){
  security_hole(0);
}
