###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openssl_mult_dos_vuln_lin.nasl 2393 2009-05-22 12:10:29Z may $
#
# OpenSSL DTLS Packets Multiple Denial of Service Vulnerabilities (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

  desc1 = "
  Multiple flaws are due to,
  - The library does not limit the number of buffered DTLS records with a
    future epoch.
  - An error when processing DTLS messages can be exploited to exhaust all
    available memory by sending a large number of out of sequence handshake
    messages.

  Impact:
  Successful exploitation will let the attacker to cause denial-of-service
  conditions,crash the client,and exhaust all memory.

  Impact Level: System/Application

  Affected Software/OS:
  OpenSSL version 0.9.8 to version 0.9.8k on Linux.

  Fix: Apply patches or upgrade to the latest version.
  For updates refer,http://www.openssl.org/source/

  References:
  http://secunia.com/advisories/35128
  http://cvs.openssl.org/chngview?cn=18188
  http://www.openwall.com/lists/oss-security/2009/05/18/1

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.7
  Risk factor: Medium";

  desc2 = "
  Flaws is due to,
  - A use-after-free error in the 'dtls1_retrieve_buffered_fragment()' function
    can be exploited to cause a crash in a client context.

  Impact:
  Successful exploitation will let the attacker to cause denial-of-service
  conditions,crash the client,and exhaust all memory.

  Impact Level: System/Application

  Affected Software/OS:
  OpenSSL version 1.0.0 Beta2 and prior on Linux.

  Fix: Apply patches or upgrade to the latest version.
  http://rt.openssl.org/Ticket/Display.html?id=1923&user=guest&pass=guest

  References:
  https://launchpad.net/bugs/cve/2009-1379
  http://www.openwall.com/lists/oss-security/2009/05/18/4

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.7
  Risk factor: Medium";

if(description)
{
  script_id(900653);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1377", "CVE-2009-1378", "CVE-2009-1379");
  script_bugtraq_id(35001);
  script_name("OpenSSL DTLS Packets Multiple Denial of Service Vulnerabilities (Linux)");
  script_description(desc1);
  script_description(desc2);
  script_summary("Check for the version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_openssl_detect_lin.nasl");
  script_require_keys("OpenSSL/Linux/Ver");
  exit(0);
}


include ("version_func.inc");

opensslVer = get_kb_item("OpenSSL/Linux/Ver");
if(opensslVer == NULL){
  exit(0);
}

opensslVer = ereg_replace(pattern:"-", string:opensslVer, replace: ".");
report =  string("\n Overview: This host is running OpenSSL and is prone to" +
                 "\n Multiple Denial of Service Vulnerabilities (Linux) \n" +
                 "\n Vulnerability Insight:");

if(version_in_range(version:opensslVer, test_version:"0.9.8", test_version2:"0.9.8k"))
{
   security_warning(data:string(report, desc1));
   exit(0);
 }

if(version_is_less_equal(version:opensslVer, test_version:"1.0.0.beta2")){
   security_warning(data:string(report, desc2));
}
