###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openoffice_emf_mult_bof_vuln_win.nasl 4911 2009-09-22 17:45:56 sep $
#
# OpenOffice EMF Files Multiple Buffer Overflow Vulnerabilities (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900954);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2140");
  script_name("OpenOffice EMF Files Multiple Buffer Overflow Vulnerabilities (Win)");
  desc = "
  Overview: The host has OpenOffice installed and is prone to Multiple Buffer
  Overflow vulnerabilities.

  Vulnerability Insight:
  The Multiple flaws are due to buffer overflow error in cppcanvas/source/
  mtfrenderer/emfplus.cxx when processing crafted EMF+ files.

  Impact:
  Successful remote exploitation could result in arbitrary code execution.

  Impact Level: Application

  Affected Software/OS:
  OpenOffice 2.x and 3.x before 3.0.1 on Windows.

  Fix: Upgrade to OpenOffice 3.0.1 or later.
  http://www.openoffice.org/

  References:
  http://marc.info/?l=oss-security&m=125258116800739&w=2
  http://marc.info/?l=oss-security&m=125265261125765&w=2

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_openoffice_detect_win.nasl");
  script_require_keys("OpenOffice/Win/Ver");
  exit(0);
}


include("version_func.inc");

openVer = get_kb_item("OpenOffice/Win/Ver");
if(!openVer){
  exit(0);
}

if(openVer =~ "^(2|3)\..*")
{
  if(version_is_less(version:openVer, test_version:"3.0.1")){
    security_hole(0);
  }
}
