#############################################################################
#
#  OpenOffice rtl_allocateMemory() Remote Code Execution Vulnerability (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/29
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0154
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
###########################################################################

if(description)
{
 script_id(900042);
 script_bugtraq_id(30866);
 script_cve_id("CVE-2008-3282");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("OpenOffice rtl_allocateMemory() Remote Code Execution Vulnerability (Win)");
 script_summary("Check for the vulnerable version of OpenOffice.org");
 desc = "
 Overview : This host has OpenOffice.Org installed, which is prone to remote
 code execution vulnerability.

 Vulnerability Insight :

        The issue is due to a numeric truncation error within the rtl_allocateMemory()
        method in alloc_global.c file.

        Impact : Attackers can cause an out of bounds array access by tricking a
        user into opening a malicious document, also allow execution of arbitrary
        code.

 Impact Level : System

 Affected Software/OS :
        OpenOffice.org 2.4.1 and prior on Windows.

 Fix : No solution/patch is available as on 29th August, 2008. Information
 regarding this issue will updated once the solution details are available.
 For updates refer, http://download.openoffice.org/index.html

 References : http://secunia.com/advisories/31640/
 http://www.frsirt.com/english/advisories/2008/2449

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.8
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();
 
 if(!port) port = 139;
 
 if(!get_port_state(port))exit(0);
 
 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }
 
 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }
 
 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }
 
 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r)
 {
        close(soc);
        exit(0);
 }
 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
        close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe)
 {
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
        close(soc);
        exit(0);
 }
 
 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe,
                          key:key, reply:handle);
 if(!key_h)
 {
        close(soc);
        exit(0);
 }

 entries = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
 close(soc);

 foreach item (entries)
 {
        if("OpenOffice.org" >< registry_get_sz(key:key + item, item:"DisplayName"))
        {
		# Grep <= 2.4.9310 (ie., 2.4.1)
 		if((egrep(pattern:"^([01]\..*|2\.([0-3](\..*)?|4(\.([0-8]?[0-9]?" +
				  "[0-9]?[0-9]|9[0-2][0-9][0-9]|930[0-9]|9310))?))$",
                    	  string:registry_get_sz(key:key + item,
                    	  item:"DisplayVersion")))){
			security_warning(0);
		}
		exit(0);
        }
 }
