##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openfire_mult_vuln_mar09.nasl 1114 2009-03-25 17:30:29Z mar $
#
# Openfire Multiple Vulnerabilities (Mar09)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900484);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6511", "CVE-2008-6510", "CVE-2008-6508", "CVE-2008-6509");
  script_bugtraq_id(32189);
  script_name("Openfire Multiple Vulnerabilities (Mar09)");
  desc = "

  Overview: This host is running Openfire and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are due to,
  - error in the AuthCheckFilter which causes access to administrative
    resources without admin authentication.
  - error in the type parameter inside the file 'sipark-log-summary.jsp'
    which causes SQL Injection attack.
  - error in the 'login.jsp' URL parameter which accept malicious chars
    as input which causes XSS attack.
  - error in the SIP-Plugin which is deactivated by default which lets the
    attack install the plugin by using admin authentication bypass methods.

  Impact:
  Successful exploitation will let the attacker cause multiple attacks in
  the context of the application i.e. Cross site scripting, disclosure of
  sensitive information, phishing attacks through the affected parameters.

  Impact level: Application/Network

  Affected Software/OS:
  Openfire version prior to 3.6.1

  Fix: Upgrade to the version 3.6.1 or later.
  http://www.igniterealtime.org/downloads/index.jsp

  References:
  http://secunia.com/advisories/32478
  http://www.milw0rm.com/exploits/7075
  http://www.andreas-kurtz.de/advisories/AKADV2008-001-v1.0.txt
  http://www.igniterealtime.org/builds/openfire/docs/latest/changelog.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Openfire");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_openfire_detect.nasl");
  script_require_ports("Services/www", 9090);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

firePort = get_http_port(default:9090);
if(!firePort){
  exit(0);
}

fireVer = get_kb_item("www/" + firePort + "/Openfire");
if(fireVer != NULL)
{
  # Grep for Openfire version prior to 3.6.1
  if(version_is_less(version:fireVer, test_version:"3.6.1")){
    security_hole(firePort);
  }
}
