##############################################################################
#
#  NuMedia Soft DVD Burning SDK Activex Control Remote Code Execution Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/25
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0272
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900132);
  script_bugtraq_id(31374);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.1 ");
  script_category(ACT_GATHER_INFO);
  script_family("General");
  script_name("NuMedia Soft DVD Burning SDK Activex Control Remote Code Execution Vulnerability");
  script_summary("Check for vulnerable version of CDBurnerXP");
  desc = "

  Overview : The host is installed CDBurnerXP, which is prone to ActiveX control
  based remote code execution vulnerability.

  Vulnerability Insight :
  The flaw is caused due to an error in validating/sanitizing the input data
  sent to NMSDVDX.dll file.

  Impact : Exploitation will cause Internet Explorer to restrict the webpage
  from running scripts and could overwrite files with arbitrary content.

  Impact Level : Application

  Affected Software/OS :
  CDBurnerXP versions 4.2.1.976 and prior on all platform
 
  Fix : No solution/patch is available as on 24th September, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates check, http://www.nugroovz.com/Downloads.aspx

  References :
  http://cdburnerxp.se/en/home
  http://www.milw0rm.com/exploits/6491

  CVSS Score :
    CVSS Base Score     : 5.1 (AV:N/AC:H/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 4.6
  Risk factor : Medium";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}

include("smb_nt.inc");
include("secpod_smb_func.inc");
 
if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}
 
cdBurnerXpPath = registry_get_sz(item:"ImagePath",
                                 key:"SYSTEM\ControlSet001\Services\NMSAccessU");
if(!cdBurnerXpPath){
  exit(0);
}

cdBurnerXpPath = cdBurnerXpPath - "\NMSAccessU.exe" + "\cdbxpp.exe";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:cdBurnerXpPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:cdBurnerXpPath);

soc = open_sock_tcp(port);
if(!soc){
  exit(0);
}

r = smb_session_request(soc:soc, remote:name);
if(!r){
   close(soc);
   exit(0);
}

prot = smb_neg_prot(soc:soc);
if(!prot){
  close(soc);
  exit(0);
}

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                      prot:prot);
if(!r){
  close(soc);
  exit(0);
}

uid = session_extract_uid(reply:r);
r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

tid = tconx_extract_tid(reply:r);
if(!tid){
  close(soc);
  exit(0);
}

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(!fid){
  close(soc);
  exit(0);
}

cdBurnerXpVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod");
close(soc);
 
# grep for versions 4.2.1.976 and prior
if(egrep(pattern:"^([0-3]\..*|4\.([01](\..*)?|2\.(0(\..*)?|1\.([0-8]?[0-9]?" +
		 "[0-9]|9[0-6][0-9]|97[0-6]))))$", string:cdBurnerXpVer)){
  security_warning(0);
}
