###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mysql_bof_vuln_lin.nasl 6504 2009-12-31 23:29:17Z dec $
#
# MySQL Server Buffer Overflow Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901093);
  script_version("$Revision: 6302 $: 1.0");
  script_cve_id("CVE-2009-4484");
  script_name("MySQL Server Buffer Overflow Vulnerability (Linux)");
  desc = "
  Overview: The host is running MySQL and is prone to Buffer overflow
  Vulnerability

  Vulnerability Insight:
  The flaw is due to an error in application that allows remote attackers to
  execute arbitrary code via unspecified vectors

  Impact:
  Successful exploitation could allow attackers to execute arbitrary code.

  Impact Level: Application

  Affected Software/OS:
  MySQL Version 5.0.51a On Linux

  Fix: No solution/patch is available as on 31st December, 2009. Information
  regarding this issue will be updated once the solution details are available
  For Updates Refer, http://dev.mysql.com/downloads

  References:
  http://intevydis.com/vd-list.shtml
  http://www.intevydis.com/blog/?p=57

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of MySQL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Databases");
  script_dependencies("mysql_version.nasl");
  script_require_ports("Services/mysql", 3306);
  exit(0);
}


include("misc_func.inc");
include("version_func.inc");

sqlPort = get_kb_item("Services/mysql");
if(!sqlPort){
  sqlPort = 3306;
}

if(!get_port_state(sqlPort)){
  exit(0);
}

mysqlVer = get_mysql_version(port:sqlPort);
if(isnull(mysqlVer)){
  exit(0);
}

mysqlVer = eregmatch(pattern:"([0-9.a-z]+)", string:mysqlVer);
if(!isnull(mysqlVer[1]))
{
  if(version_is_equal(version:mysqlVer[1], test_version:"5.0.51a")){
    security_hole(sqlPort);
  }
}
