##############################################################################
#
#  Microsoft Word Could Allow Remote Code Execution Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/07/10
#
#  Revision: 1.3
#
#  Log: schandan
#  Issue #0021
#
#  Make use of version_func_inc - By Chandan S, 11:48:13 2009/04/24
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900006);
 script_bugtraq_id(30124);
 script_cve_id("CVE-2008-2244");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.3 ");
 script_category(ACT_GATHER_INFO);
 script_family("Windows");
 script_name("Microsoft Word Could Allow Remote Code Execution Vulnerability");
 script_summary("Check for Microsoft Word file version");
 desc = "
 MS08-042

 Overview : This host is installed with Microsoft Office (with MS Word), which
 is prone to remote code execution vulnerability.

 Vulnerability Insight :
 Flaw is due to an error within the handling of malformed/crafted MS Word documents.

 Impact : Remote attacker could exploit by persuading victim to open a crafted
 documents to corrupt memory and cause the application to crash, and also allow
 to execute arbitrary code with the system privileges of the victim.

 Impact Level : System

 Affected Software/OS :
 Microsoft Word 2002 (XP) with SP3 on Windows (All).
 Microsoft Word 2003 with SP3 on Windows (All).

 Fix : Run Windows Update and update the listed hotfixes or download and
 update mentioned hotfixes in the advisory from the below link.
 http://www.microsoft.com/technet/security/bulletin/ms08-042.mspx

 References :
 http://secunia.com/advisories/30975
 http://xforce.iss.net/xforce/xfdb/43663
 http://www.frsirt.com/english/advisories/2008/2028
 http://www.microsoft.com/technet/security/advisory/953635.mspx
 http://www.microsoft.com/technet/security/bulletin/ms08-042.mspx

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.0
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl", "secpod_office_products_version_900032.nasl",
		     "secpod_ms_office_detection_900025.nasl");
 script_require_keys("SMB/WindowsVersion", "SMB/Office/Word/Version");
 script_require_ports(139, 445);
 exit(0);
}


include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(egrep(pattern:"^(10|11)\..*", string:get_kb_item("MS/Office/Ver")))
{
  # Grep for version < (10.0.6846 - MS Word 2002 SP3 & 11.0.8227.0 - MS Word 2003 SP3)
  wordVer = get_kb_item("SMB/Office/Word/Version");
  if(!wordVer){
    exit(0);
  }

  if(version_in_range(version:wordVer, test_version:"10.0",
                      test_version2:"10.0.6845")){
    security_hole(0);
  }
  else if(version_in_range(version:wordVer, test_version:"11.0",
                           test_version2:"11.0.8226")){
    security_hole(0);
  }
}
