##############################################################################
#
#  Microsoft SQL Server 2000 sqlvdir.dll ActiveX Buffer Overflow Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/15
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0195
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900125);
 script_bugtraq_id(31129);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("Microsoft SQL Server 2000 sqlvdir.dll ActiveX Buffer Overflow Vulnerability");
 script_summary("Check for vulnerable version of Microsoft SQL Server 2000");
 desc = "
 Overview : The host is running Microsoft SQL Server, which is prone to 
 buffer-overflow vulnerability.

 Vulnerability Insight :
 Applications sqlvdir.dll ActiveX control is prone to a buffer-overflow
 vulnerability because it fails to bounds-check user-supplied data
 before copying it into an insufficiently sized buffer. The issue occurs
 when excessive amounts of data to the Control() method is passed.

 Impact : Successful exploitation allows remote attackers to execute
 arbitrary code and failed attepts causes denial-of-service conditions.

 Impact Level : Application

 Affected Software/OS :
 Microsoft SQL Server 2000 SP4 and prior on Windows (all)
 
 Fix : No solution/patch is available as on 15th September, 2008.
 Information regarding this issue will be updated once the solution details
 are available. For updates check,
 http://www.microsoft.com/sqlserver

 References :
 http://support.microsoft.com/kb/240797
 http://www.securityfocus.com/archive/1/496232
 http://www.juniper.net/security/auto/vulnerabilities/vuln31129.html

 CVSS Score :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 7.5
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 msSqlPort = 1433;

 if(!get_port_state(msSqlPort)){
        exit(0);
 }

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 msSqlVer = registry_get_sz( key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                     "\Uninstall\Microsoft SQL Server 2000",
                                  item:"DisplayVersion");

 if(egrep(pattern:"^([0-7]\..*|8\.(0?0(\.([0-9]?[0-9]|1[0-8][0-9]|19[0-4]))?" +
                  "))$", string:msSqlVer)){
      security_hole(0);
 }
