###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_unicode_str_dos_vuln.nasl 3625 2009-07-23 17:29:29Z jul $
#
# Microsoft Internet Explorer Unicode String DoS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900400);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2576");
  script_name("Microsoft Internet Explorer Unicode String DoS Vulnerability");
  desc = "

  Overview: This host is installed with Internet Explorer and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  Error exists when application fails to handle user supplied input into the
  'write' method via a long Unicode string argument.

  Impact:
  Successful exploitation lets the attacker to cause memory or CPU consumption,
  resulting in Denial of Service condition.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Explorer version 6.0.2900.2180 and prior

  Fix: No solution or patch is available as on 23rd July 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www.microsoft.com/windows/internet-explorer/download-ie.aspx

  References:
  http://websecurity.com.ua/3338/
  http://www.securityfocus.com/archive/1/archive/1/505122/100/0/threaded
  http://www.securityfocus.com/archive/1/archive/1/505120/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

if(version_is_less_equal(version:ieVer, test_version:"6.0.2900.2180")){
  security_warning(0);
}
