###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_arg_inj_vuln.nasl 796 2008-12-31 13:24:24Z dec $
#
# Microsoft Internet Explorer Argument Injection Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900187);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5750");
  script_name("Microsoft Internet Explorer Argument Injection Vulnerability");
  desc = "

  Overview: This host has installed Internet Explorer and is prone to Argument
  Injection vulnerability.

  Vulnerability Insight:
  The flaw is due to lack of sanitization check of user supplied input which
  causes remote command execution in the context of the application via
  --renderer-path option in a chromehtml: URI.

  Impact:
  Successful exploitation will allow attackers to execute arbitrary codes with
  the user privileges and cause argument injection in the context of the
  vulnerable application.

  Impact Level: Application

  Affected Software/OS:
  Microsoft, Internet Explorer version 8 beta 2 and prior on Windows.

  Fix: No solution or patch is available as on 31st December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/downloads/ie/getitnow.mspx

  References:
  http://www.milw0rm.com/exploits/7566
  http://retrogod.altervista.org/9sg_chrome.html

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# Check for Internet Explorer version 8.0 to 8.0.6001.18241
if(version_in_range(version:ieVer, test_version:"8.0",
                    test_version2:"8.0.6001.18241")){
  security_warning(0);
}
