###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-059.nasl 5266 2009-10-14 03:48:09Z oct $
#
# Microsoft Windows LSASS Denial of Service Vulnerability (975467)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900877);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2524");
  script_bugtraq_id(36593);
  script_name("Microsoft Windows LSASS Denial of Service Vulnerability (975467)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-059.

  Vulnerability Insight:
  This issue is caused by an integer underflow error in the Windows NTLM
  implementation in LSASS (Local Security Authority Subsystem Service) when
  processing malformed packets during the authentication process, which could
  allow attackers to cause an affected system to automatically reboot.

  Impact:
  Successful exploitation will let the remote attackers to cause a Denial of
  Service on the victim's system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows XP  Service Pack 3 and prior.
  Microsoft Windows 2K3 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-059.mspx

  References:
  http://support.microsoft.com/kb/975467
  http://www.vupen.com/english/advisories/2009/2894
  http://www.microsoft.com/technet/security/bulletin/MS09-059.mspx

  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Msv1_0.dll file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2003:3) <= 0){
  exit(0);
}

# Check KB968389 is installed, vulnerability exists only if this is installed.
if(hotfix_missing(name:"968389") == 1){
  exit(0);
}

# MS09-059 Hotfix check
if(hotfix_missing(name:"975467") == 0){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\Msv1_0.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Msv1_0.dll < 5.1.2600.3625
    if(version_is_less(version:dllVer, test_version:"5.1.2600.3625")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Msv1_0.dll < 5.1.2600.5876
    if(version_is_less(version:dllVer, test_version:"5.1.2600.5876")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Msv1_0.dll version < 5.2.3790.4587
    if(version_is_less(version:dllVer, test_version:"5.2.3790.4587")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
