###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-044.nasl 3926 2009-08-12 10:54:09Z aug $
#
# Microsoft Remote Desktop Connection Remote Code Execution Vulnerability (969706)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900813);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1133", "CVE-2009-1929");
  script_bugtraq_id(35971, 35973);
  script_name("Microsoft Remote Desktop Connection Remote Code Execution Vulnerability (969706)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-044.

  Vulnerability Insight:
  - Error exists when processing specific parameters returned by the RDP server,
    which could be exploited to cause a heap-based buffer overflow by tricking a
    user into connecting to a malicious RDP server.
  - An heap-based buffer overflow error in the Remote Desktop Web Connection
    ActiveX control when processing malformed parameters, which can be exploited
    via specially crafted web page.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code which may
  result in heap-based buffer overflow on the affected system.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Windows 2k  Service Pack 4 and prior
  Microsoft Windows XP  Service Pack 3 and prior
  Microsoft Windows 2k3 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-044.mspx

  References:
  http://secunia.com/advisories/36229/
  http://support.microsoft.com/kb/970927
  http://www.vupen.com/english/advisories/2009/2238
  http://www.microsoft.com/technet/security/bulletin/MS09-044.mspx

  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of mstscax.dll file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

# MS09-044 Hotfix check
if((hotfix_missing(name:"958469") == 0)||(hotfix_missing(name:"958470") == 0)||
   (hotfix_missing(name:"958471") == 0)||(hotfix_missing(name:"956744") == 0)){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\Mstscax.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Mstscax.dll version < 5.1.2600.3581 (For RDP v5.0, v5.1, v5.2)
  if(version_is_less(version:dllVer, test_version:"5.1.2600.3581")){
    security_hole(0);
  }
}

# Windows XP
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Mstscax.dll < 5.1.2600.3581 (vRDP v5.1, v5.2) or
    # 6.0.6000.00000 < 6.0.6000.16865 (RDP v6.0) or 6.0.6001.00000 < 6.0.6001.22443 (RDP v6.1)
    if(version_is_less(version:dllVer, test_version:"5.1.2600.3581")||
       version_in_range(version:dllVer, test_version:"6.0.6000.00000", test_version2:"6.0.6000.16864")||
       version_in_range(version:dllVer, test_version:"6.0.6001.00000", test_version2:"6.0.6001.22442")){
      security_hole(0);
    }
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Mstscax.dll < 5.1.2600.3581 (RDP v5.2) or 6.0 < 6.0.6001.18266 (RDP v6.1)
    if(version_is_less(version:dllVer, test_version:"5.1.2600.3581")||
       version_in_range(version:dllVer, test_version:"6.0.6001.00000", test_version2:"6.0.6001.18265")){
      security_hole(0);
    }
  }
}
# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Mstscax.dll version < 5.2.3790.4524 (RDP v5.2), 6.0 < 6.0.6000.16865 (RDP v6.0)
    if(version_is_less(version:dllVer, test_version:"5.2.3790.4524") ||
       version_in_range(version:dllVer, test_version:"6.0", test_version2:"6.0.6000.16864")){
      security_hole(0);
    }
  }
}
