###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-042.nasl 3928 2009-08-12 14:17:48Z aug $
#
# Telnet NTLM Credential Reflection Authentication Bypass Vulnerability (960859)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900909);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1930");
  script_bugtraq_id(35993);
  script_name("Telnet NTLM Credential Reflection Authentication Bypass Vulnerability (960859)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-042.

  Vulnerability Insight:
  An error in the Telnet service when handling NTLM authentication can be
  exploited to reflect the user credentials and gain unauthorized access
  to the affected system.

  Impact:
  Succesful exploitation will allow attackes to execute arbitrary code and
  completely compromise the affected computer.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-042.mspx

  References:
  http://secunia.com/advisories/36222/
  http://support.microsoft.com/kb/960859
  http://www.microsoft.com/technet/security/Bulletin/MS09-042.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# MS09-042 Hotfix (960859)
if(hotfix_missing(name:"960859") == 0){
  exit(0);
}

exePath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
if(!exePath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath +
                                                         "\telnet.exe");
telnetVer = GetVer(file:file, share:share);
if(!telnetVer){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for telnet.exe version 5.0 < 5.0.33670.4
  if(version_in_range(version:telnetVer, test_version:"5.0",
                      test_version2:"5.0.33670.3")){
    security_hole(0);
  }
}

else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for telnet.exe version 5.1 < 5.1.2600.3587
    if(version_in_range(version:telnetVer, test_version:"5.1",
                        test_version2:"5.1.2600.3586")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for telnet.exe version 5.1 < 5.1.2600.5829
    if(version_in_range(version:telnetVer, test_version:"5.1",
                        test_version2:"5.1.2600.5828")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for telnet.exe version 5.2 < 5.2.3790.4528
    if(version_in_range(version:telnetVer, test_version:"5.2",
                        test_version2:"5.2.3790.4527")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
