###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-041.nasl 3940 2009-08-12 09:14:35Z aug $
#
# Vulnerability in Workstation Service Could Allow Elevation of Privilege (971657)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(101102);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1544");
  script_bugtraq_id(35972);
  script_name("Vulnerability in Workstation Service Could Allow Elevation of Privilege (971657)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-041.

  Vulnerability Insight:
  The flaw is caused due to a double free error while processing arguments
  passed to the 'NetrGetJoinInformation()' function. This can be exploited to
  trigger a memory corruption via a specially crafted RPC request.

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary
  code with SYSTEM privileges, and can cause Denial of Service.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Windows XP  Service Pack 3 and prior
  Microsoft Windows 2k3 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-041.mspx

  References:
  http://secunia.com/advisories/36220/
  http://support.microsoft.com/kb/971657
  http://www.vupen.com/english/advisories/2009/2236
  http://www.microsoft.com/technet/security/bulletin/ms09-041.mspx

  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable DLL file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

if(hotfix_missing(name:"971657") == 0){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
 exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\wkssvc.dll");
wkssvcVer = GetVer(file:file, share:share);

if(!wkssvcVer){
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for wkssvc.dll < 5.1.2600.3584
    if(version_is_less(version:wkssvcVer, test_version:"5.1.2600.3584")){
      security_hole(0);
    }
    exit(0);
  }
  if("Service Pack 3" >< SP)
  {
    # Grep for wkssvc.dll < 5.1.2600.5826
    if(version_is_less(version:wkssvcVer, test_version:"5.1.2600.5826")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for wkssvc.dll version < 5.2.3790.4530
    if(version_is_less(version:wkssvcVer, test_version:"5.2.3790.4530")){
      security_hole(0);
    }
  }
}
