###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-034.nasl 3689 2009-07-29 10:11:42Z jul $
#
# Cumulative Security Update for Internet Explorer (972260)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900906);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-1917", "CVE-2009-1918", "CVE-2009-1919");
  script_bugtraq_id(35831, 35827);
  script_name("Cumulative Security Update for Internet Explorer (972260)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-034.

  Vulnerability Insight:
  Multiple errors occur due to the way IE
  - handles memory objects,
  - handles table operations,
  - access a previously deleted object.

  Impact:
  Specially crafted HTML page will let the attacker execute arbitrary
  codes in the context of the affected system and cause memory corruption.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Internet Explorer version 5.x/6.x/7.x/8.x

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-034.mspx

  References:
  http://support.microsoft.com/kb/972260
  http://www.microsoft.com/technet/security/Bulletin/MS09-034.mspx

  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the vulnerable DLL file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# MS09-034 Hotfix (972260)
if(hotfix_missing(name:"972260") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
dllPath += "\mshtml.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

vers = GetVer(file:file, share:share);
if(!vers){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for mshtml.dll version 5.0 < 5.0.3879.2200 or 6.0 < 6.0.2800.1634
  if(version_in_range(version:vers, test_version:"5.0",
                       test_version2:"5.0.3879.2199") ||
     version_in_range(version:vers, test_version:"6.0",
                       test_version2:"6.0.2800.1633")){
     security_hole(0);
  }

  security_hole(0);
}

else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.2900.3603
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.2900.3602")){
      security_hole(0);
    }
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.2900.5848 or 7.0 < 7.0.6000.16890
    # or 8.0 < 8.0.6001.18806
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.2900.5847") ||
       version_in_range(version:vers, test_version:"7.0",
                        test_version2:"7.0.6000.16889") ||
       version_in_range(version:vers, test_version:"8.0",
                        test_version2:"8.0.6001.18805")){
      security_hole(0);
    }
  }
  security_hole(0);
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.3790.4555 or 7.0 < 7.0.6000.16890
    # or 8.0 < 8.0.6001.18812
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.3790.4554") ||
      version_in_range(version:vers, test_version:"7.0",
                        test_version2:"7.0.6000.16889") ||
      version_in_range(version:vers, test_version:"8.0",
                        test_version2:"8.0.6001.18811")){
      security_hole(0);
    }
  }
  security_hole(0);
}
