###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-001.nasl 846 2009-01-14 09:14:35Z jan $
#
# Vulnerabilities in SMB Could Allow Remote Code Execution (958687)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900069);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4114", "CVE-2008-4834", "CVE-2008-4835");
  script_bugtraq_id(31179);
  script_name("Vulnerabilities in SMB Could Allow Remote Code Execution (958687)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-001.

  Vulnerability Insight:
  The issue is due to the way Server Message Block (SMB) Protocol software
  handles specially crafted SMB packets.

  Impact: Successful exploitation could allow remote unauthenticated attackers
  to cause denying the service by sending a specially crafted network message
  to a system running the server service.

  Impact Level: System/Network

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-001.mspx

  References:
  http://www.milw0rm.com/exploits/6463
  http://www.microsoft.com/technet/security/bulletin/ms09-001.mspx

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 5.6
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check Hotfix Missing 958687 (MS09-001)
if(hotfix_missing(name:"958687") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\drivers\Srv.sys");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Srv.sys version < 5.0.2195.7222
  if(version_is_less(version:sysVer, test_version:"5.0.2195.7222")){
    security_hole(0);
  }
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Srv.sys < 5.1.2600.3491
    if(version_is_less(version:sysVer, test_version:"5.1.2600.3491")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Srv.sys < 5.1.2600.5725
    if(version_is_less(version:sysVer, test_version:"5.1.2600.5725")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep for Srv.sys version < 5.2.3790.3260
    if(version_is_less(version:sysVer, test_version:"5.2.3790.3260")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep for Srv.sys version < 5.2.3790.4425
    if(version_is_less(version:sysVer, test_version:"5.2.3790.4425")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
