###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms08-076.nasl 638 2008-12-10 11:31:47Z dec $
#
# Vulnerabilities in Windows Media Components Could Allow Remote Code Execution (959807)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright: SecPod
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900060);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-3009", "CVE-2008-3010");
  script_bugtraq_id(32653, 32654);
  script_name("Vulnerabilities in Windows Media Components Could Allow Remote Code Execution (959807)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-076.

  Vulnerability Insight:
  The flaws are caused due to,
  - an error within the Service Principal Name (SPN) implementation when
    handling NTLM credentials.
  - an error when handling ISATAP URLs.

  Impact:
  Successful exploitation could allow attackers to disclose NTLM credentials
  to gain access with the privileges of a target user via replay attacks.

  Impact Level: System

  Affected Software/OS: Microsoft Windows 2K/XP/2003

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms08-076.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms08-076.mspx

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

function get_version(dllFile)
{
  dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
  if(!dllPath){
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                       string:dllPath + dllFile);

  dllVer = GetVer(file:file, share:share);
  return dllVer;
}


# Windows Media Player 6.4 on 2K/XP/2003
activeKey = "SOFTWARE\Microsoft\Active setup\Installed Components\";
playerVer = registry_get_sz(item:"Version",
            key:"SOFTWARE\Microsoft\Active setup\Installed Components" +
                "\{22d6f312-b0f6-11d0-94ab-0080c74c7e95}");
if(playerVer)
{
  # Check for Hotfix 954600 (MS08-076).
  if(hotfix_missing(name:"954600") == 1)
  {
    dllVer = get_version(dllFile:"\Strmdll.dll");
    if(dllVer != NULL)
    {
      if(version_is_less(version:dllVer, test_version:"4.1.0.3937"))
      {
        security_hole(0);
        exit(0);
      }
    }
  }
}

# Windows Media Format Runtime 7.1, 9.0, 9.5 and 11 on 2K/XP/2003
dllVer = get_version(dllFile:"\Wmvcore.dll");
if(dllVer)
{
  # Check for Hotfix 952069 (MS08-076).
  if(hotfix_missing(name:"952069") == 1)
  {
    if(hotfix_check_sp(win2k:5) > 0)
    {
      # Check for version < 5.0.2195.7151 (7.1 and 9.0)
      if(version_is_less(version:dllVer, test_version:"9.0.0.3268")){
        security_hole(0);
      }
    }

    else if(hotfix_check_sp(xp:4) > 0)
    {
      SP = get_kb_item("SMB/WinXP/ServicePack");
      if("Service Pack 2" >< SP)
      {
        if(version_in_range(version:dllVer, test_version:"9.0",
                            test_version2:"9.0.0.3267")){
          security_hole(0);
        }
        else if(version_in_range(version:dllVer, test_version:"10.0",
                                 test_version2:"10.0.0.3702")){
          security_hole(0);
        }
        else if(version_in_range(version:dllVer, test_version:"11.0",
                                 test_version2:"11.0.5721.5250")){
          security_hole(0);
        }
      }
      else if("Service Pack 3" >< SP)
      {
        if(version_in_range(version:dllVer, test_version:"9.0",
                            test_version2:"9.0.0.4503")){
          security_hole(0);
        }
        else if(version_in_range(version:dllVer, test_version:"10.0",
                                 test_version2:"10.0.0.3702")){
          security_hole(0);
        }
        else if(version_in_range(version:dllVer, test_version:"11.0",
                                 test_version2:"11.0.5721.5250")){
          security_hole(0);
        }
      }
      else security_hole(0);
    }

    else if(hotfix_check_sp(win2003:3) > 0)
    {
      SP = get_kb_item("SMB/Win2003/ServicePack");
      if("Service Pack 1" >< SP)
      {
        if(version_in_range(version:dllVer, test_version:"10.0",
                            test_version2:"10.0.0.3710")){
          security_hole(0);
        }
      }
      else if("Service Pack 2" >< SP)
      {
        if(version_in_range(version:dllVer, test_version:"10.0",
                            test_version2:"10.0.0.4000")){
          security_hole(0);
        }
      }
      else security_hole(0);
    }
  }
}

# Windows Media Services 4.1 and 9.0 on 2K/2003
# Check for Hotfix 952068 (MS08-076).
if(hotfix_missing(name:"952068") == 1)
{
  if(hotfix_check_sp(win2k:5) > 0)
  {
    dllVer = get_version(dllFile:"\windows media\server\Nsum.exe");
    if(dllVer != NULL)
    {
      if(version_is_less(version:dllVer, test_version:"4.1.0.3936")){
        security_hole(0);
      }
    }
  }
  else if(hotfix_check_sp(win2003:3) > 0)
  {
    dllVer = get_version(dllFile:"\windows media\server\Wmsserver.dll");
    if(dllVer != NULL)
    {
      SP = get_kb_item("SMB/Win2003/ServicePack");
      if("Service Pack 1" >< SP)
      {
        if(version_is_less(version:dllVer, test_version:"9.1.1.3845")){
          security_hole(0);
        }
      }
      else if("Service Pack 2" >< SP)
      {
        if(version_is_less(version:dllVer, test_version:"9.1.1.5000")){
          security_hole(0);
        }
      }
      else security_hole(0);
    }
  }
}
