###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms08-071.nasl 637 2008-12-10 09:16:04Z dec $
#
# Vulnerabilities in GDI Could Allow Remote Code Execution (956802)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright: SecPod
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900059);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-2249", "CVE-2008-3465");
  script_bugtraq_id(32634, 32637);
  script_name("Vulnerabilities in GDI Could Allow Remote Code Execution (956802)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-071.

  Vulnerability Insight:
  The flaw caused due to,
  - overflow error in GDI when processing headers in Windows Metafile (WMF)
    files.
  - an error exists in the the way the GDI handles file size parameters in
    WMF files.

  Impact:
  Successful exploitation could execute arbitrary code on the remote system
  and cause heap based buffer overflow via a specially crafted WMF file.

  Impact Level: System

  Affected Software/OS: Microsoft Windows 2K/XP/2003

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms08-071.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms08-071.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# Check for Hotfix 956802 (MS08-071).
if(hotfix_missing(name:"956802") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\gdi32.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for gdi32.dll version < 5.0.2195.7205
  if(version_is_less(version:dllVer, test_version:"5.0.2195.7205")){
     security_hole(0);
  }
}

else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for gdi32.dll version < 5.1.2600.3466
    if(version_is_less(version:dllVer, test_version:"5.1.2600.3466")){
      security_hole(0);
    }
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for gdi32.dll version < 5.1.2600.5698
    if(version_is_less(version:dllVer, test_version:"5.1.2600.5698")){
      security_hole(0);
    }
  }
  else security_hole(0);
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Check for gdi32.dll version < 5.2.3790.3233
    if(version_is_less(version:dllVer, test_version:"5.2.3790.3233")){
      security_hole(0);
    }
  }
  else if("Service Pack 2" >< SP)
  {
    # Check for gdi32.dll version < 5.2.3790.4396
    if(version_is_less(version:dllVer, test_version:"5.2.3790.4396")){
      security_hole(0);
    }
  }
  else security_hole(0);
}
