##############################################################################
#
#  Microsoft Ancillary Function Driver Elevation of Privilege Vulnerability (956803)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.0
#
#  Log: veerendragg
#  Issue #0327
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900223);
  script_bugtraq_id(31673);
  script_cve_id("CVE-2008-3464");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("Windows : Microsoft Bulletins");
  script_name("Microsoft Ancillary Function Driver Elevation of Privilege Vulnerability (956803)");
  script_summary("Check for the Hotfix and version of MS08-066");
  desc = "
  MS08-066

  Overview: This host is missing important security update according to
  Microsoft Bulletin MS08-066.

  Vulnerability Insight:
  The flaw exists due to the Ancillary Function Driver (afd.sys) not properly
  checking user supplied memory ranges before writing to them into location.

  Impact: Successful exploitation could allow an attacker to run arbitrary
  code in kernal mode with elevated privileges and take complete control of
  an affected system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows Server 2003 Service Pack 2 and prior.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/Bulletin/MS08-066.mspx

  References: http://www.microsoft.com/technet/security/Bulletin/MS08-066.mspx

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor : Medium";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}

include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2003:3) <= 0){
  exit(0);
}

sysFile = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
if(!sysFile){
  exit(0);
}

# Check for Hotfix 956803 (MS08-066)
if(hotfix_missing(name:"956803") == 0){
  exit(0);
}

sysFile += "\drivers\Afd.sys";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysFile);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysFile);

fileVer = GetVer(file:file, share:share);
if(fileVer == NULL){
  exit(0);
}

if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep Afd.sys version < 5.1.2600.3427
    if(egrep(pattern:"^5\.1\.2600\.([0-2]?[0-9]?[0-9]?[0-9]|3([0-3][0-9]" +
                     "[0-9]|4([01][0-9]|2[0-6])))$", string:fileVer)){
      security_warning(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep Afd.sys version < 5.1.2600.5657
    if(egrep(pattern:"^5\.1\.2600\.([0-4]?[0-9]?[0-9]?[0-9]|5([0-5][0-9]" +
                     "[0-9]|6([0-4][0-9]|5[0-6])))$", string:fileVer)){
      security_warning(0);
    }
    exit(0);
  }
  security_warning(0);
}

if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep Afd.sys version < 5.2.3790.3192
    if(egrep(pattern:"^5\.2\.3790\.([0-2]?[0-9]?[0-9]?[0-9]|3(0[0-9][0-9]" +
                     "|1([0-8][0-9]|9[01])))$", string:fileVer)){
      security_warning(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep Afd.sys version < 5.2.3790.4355
    if(egrep(pattern:"^5\.2\.3790\.([0-3]?[0-9]?[0-9]?[0-9]|4([0-2][0-9]" +
                     "[0-9]|3([0-4][0-9]|5[0-4])))$", string:fileVer)){
      security_warning(0);
    }
    exit(0);
  }
  security_warning(0);
}
