##############################################################################
#
#  Active Directory Could Allow Remote Code Execution Vulnerability (957280)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0326
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900050);
  script_bugtraq_id(31609);
  script_cve_id("CVE-2008-4023");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("Windows : Microsoft Bulletins");
  script_name("Active Directory Could Allow Remote Code Execution Vulnerability (957280)");
  script_summary("Check for Hotfix and version of Active Directory");
  desc = "
  MS08-060

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-060.

  Vulnerability Insight:
  The flaw is due to an incorrect memory allocation when processing LDAP
  and LDAPS requests.

  Impact: Successful exploitation could result in buffer overflow via a
  specially crafted request.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2000 Server Service Pack 4 and prior.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms08-060.mspx

  References: http://www.microsoft.com/technet/security/bulletin/ms08-060.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5) <= 0){
  exit(0);
}

# Active Directory
if(!registry_key_exists(key:"SYSTEM\CurrentControlSet\Services\NTDS\Performance")){
  exit(0);
}

# Check for Hotfix 957280 (MS08-060)
if(hotfix_missing(name:"957280") == 0){
  exit(0);
}

ntdsPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                           item:"Install Path");
if(!ntdsPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:ntdsPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:ntdsPath + "\ntdsa.dll");

ntdsVer = GetVer(file:file, share:share);
if(!ntdsVer){
  exit(0);
}

# Grep Snarpcsv.exe version < 5.0.2195.7178
if(ereg(pattern:"^5\.0\.2195\.([0-6]?[0-9]?[0-9]?[0-9]|70[0-9][0-9]|" +
                "71([0-6][0-9]|7[0-7]))$", string:ntdsVer)){
   security_hole(ldapPort);
}
