##############################################################################
#
#  Host Integration Server RPC Service Remote Code Execution Vulnerability (956695)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.0
#
#  Log: schandan
#  Issue #0325
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900049);
  script_bugtraq_id(31620);
  script_cve_id("CVE-2008-3466");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("Windows : Microsoft Bulletins");
  script_name("Host Integration Server RPC Service Remote Code Execution Vulnerability (956695)");
  script_summary("Check for Hotfix and version of Host Integration Server");
  desc = "
  MS08-059

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-059.

  Vulnerability Insight:
  The issue is due to an error in the SNA Remote Procedure Call (RPC) service.

  Impact: Successful exploitation could allow local attackers to bypass the
  authentication mechanism and can access administrative functionalities via
  a specially crafted RPC request.

  Impact Level: System

  Affected Software/OS:
  Microsoft Host Integration Server 2000/2004/2006 (Server) on Windows.
  Microsoft Host Integration Server 2000/2004 (Client) on Windows.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms08-059.mspx

  References: http://www.microsoft.com/technet/security/bulletin/ms08-059.mspx

  CVSS Score:
    CVSS Base Score     : 6.9 (AV:L/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.1
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Microsoft\Host Integration Server")){
  exit(0);
}

if(hotfix_missing(name:"956695") == 0){
  exit(0);
}

hisPath = registry_get_sz(item:"Path",
          key:"SOFTWARE\Microsoft\Host Integration Server\ConfigFramework");
if(!hisPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:hisPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:hisPath + "system\Snarpcsv.exe");

hisVer = GetVer(file:file, share:share);
# Grep Snarpcsv.exe version < 7.0.2900.0
if(ereg(pattern:"^7\.0\.([01]?[0-9]?[0-9]?[0-9]|2[0-8][0-9][0-9])\.0$",
        string:hisVer)){
   security_hole(0);
}
