##############################################################################
#
#  Windows Media Player 11 Remote Code Execution Vulnerability (954154)
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/10
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0180
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900045);
 script_bugtraq_id(30550);
 script_cve_id("CVE-2008-2253");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family("Windows : Microsoft Bulletins");
 script_name("Windows Media Player 11 Remote Code Execution Vulnerability (954154)");
 script_summary("Check for Hotfix and version of Windows Media Player");
 desc = "
 MS08-054

 Overview : This host has critical security update missing according to
 Microsoft Bulletin MS08-054.

 Vulnerability Insight :

        The flaw is caused due to an error when handling sampling rates
	in Windows Media Player.

        Impact : Remote attackers can exploit via specially crafted audio
        file stream from a server side playlist (SSPL) that could allow
        arbitrary code execution when streamed from windows media server.
        This allow attacker to compromise a user's system.

 Impact Level : System

 Affected Software/OS :
        Windows Media Player 11 on Windows XP

 Fix : Run Windows Update and update the listed hotfixes or download and
 update mentioned hotfixes in the advisory from the below link,
 http://www.microsoft.com/technet/security/bulletin/ms08-054.mspx

 References : http://www.microsoft.com/technet/security/bulletin/ms08-054.mspx

 CVSS Score :
        CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
        CVSS Temporal Score : 6.9
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_reg.inc");
 include("secpod_smb_func.inc");

 if(hotfix_check_sp(xp:4) <= 0){
	 exit(0);
 }

 function get_version()
 {
	dllPath = registry_get_sz(item:"Install Path",
                  		  key:"SOFTWARE\Microsoft\COM3\Setup");

        dllPath += "\wmpeffects.dll";

        share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
        file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

        name    =  kb_smb_name();
        login   =  kb_smb_login();
        pass    =  kb_smb_password();
        domain  =  kb_smb_domain();
        port    =  kb_smb_transport();

        soc = open_sock_tcp(port);
        if(!soc){
                exit(0);
        }

        r = smb_session_request(soc:soc, remote:name);
        if(!r)
        {
                close(soc);
                exit(0);
        } 

        prot = smb_neg_prot(soc:soc);
        if(!prot)
        {
                close(soc);
                exit(0);
        }

        r = smb_session_setup(soc:soc, login:login, password:pass,
                              domain:domain, prot:prot);
        if(!r)
        {
                close(soc);
                exit(0);
        }

        uid = session_extract_uid(reply:r);

        r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
        tid = tconx_extract_tid(reply:r);
        if(!tid)
        {
                close(soc);
                exit(0);
        }

        fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
        if(!fid)
        {
                close(soc);
                exit(0);
        }

        v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid);
	close(soc);
        return v;
 }

 if(!registry_key_exists(key:"SOFTWARE\Microsoft\MediaPlayer")){
	exit(0);
 }

 mplayerVer = registry_get_sz(key:"SOFTWARE\Microsoft\Active setup\Installed Components" +
				  "\{6BF52A52-394A-11d3-B153-00C04F79FAA6}",
			      item:"Version");

 if("11,0,5721" >< mplayerVer)
 {
	if(hotfix_missing(name:"954154") == 0){
                exit(0);
        }

	vers = get_version();
        if(vers == NULL){
                exit(0);
        }

	# Grep Wmpeffects.dll version < 11.0.5721.5252
        if(ereg(pattern:"^11\.0\.5721\.([0-4]?[0-9]?[0-9]?[0-9]|5[01][0-9][0-9]" +
			"|52[0-4][0-9]|525[01])$", string:vers)){
                security_hole(0);
	}
 }
