##############################################################################
#
#  Security Update for Outlook Express (951066)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/13
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0113
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900031);
 script_bugtraq_id(30585);
 script_cve_id("CVE-2008-1448");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Windows : Microsoft Bulletins");
 script_name("Security Update for Outlook Express (951066)");
 script_summary("Check for the vulnerable version of Microsoft Outlook");
 desc = "
 MS08-048

 Overview : This host has critical security update missing according to
 Microsoft Bulletin MS08-048.

 Vulnerability Insight :

        Issue is due to the MHTML protocol handler incorrectly interprets
        MHTML URL redirections that could potentially bypass Internet Explorer
        domain restrictions when returning MHTML content.

        Impact : Remote attackers can construct a specially crafted Web page,
        information disclosure, and could read data from another Internet
        Explorer domain or the local computer.

 Impact Level : System

 Affected Software/OS :
        MS Outlook Express 5.5 & 6 on MS Windows 2000
        MS Outlook Express 6 on MS Windows 2003 and XP

 Fix : Run Windows Update and update the listed hotfixes or download and
 update mentioned hotfixes in the advisory from the below link.
 http://www.microsoft.com/technet/security/bulletin/ms08-048.mspx

 References : http://www.microsoft.com/technet/security/bulletin/ms08-048.mspx

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.0 
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_reg.inc");
 include("secpod_smb_func.inc");

 if(hotfix_check_sp(xp:3, win2k:5, win2003:3) <= 0){
	 exit(0);
 }

 function get_version()
 {
        if(hotfix_missing(name:"951066") == 0){
                exit(0);
        } 

        dllPath = registry_get_sz(item:"Install Path",
                  key:"SOFTWARE\Microsoft\COM3\Setup");

        dllPath += "\inetcomm.dll";
        share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
        file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

        name    =  kb_smb_name();
        login   =  kb_smb_login();
        pass    =  kb_smb_password();
        domain  =  kb_smb_domain();
        port    =  kb_smb_transport();

        soc = open_sock_tcp(port);
        if(!soc){
                exit(0);
        }

        r = smb_session_request(soc:soc, remote:name);
        if(!r)
        {
                close(soc);
                exit(0);
        } 

        prot = smb_neg_prot(soc:soc);
        if(!prot)
        {
                close(soc);
                exit(0);
        }

        r = smb_session_setup(soc:soc, login:login, password:pass,
                              domain:domain, prot:prot);
        if(!r)
        {
                close(soc);
                exit(0);
        }

        uid = session_extract_uid(reply:r);

        r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
        tid = tconx_extract_tid(reply:r);
        if(!tid)
        {
                close(soc);
                exit(0);
        }

        fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
        if(!fid)
        {
                close(soc);
                exit(0);
        }

        v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod", offset:600000);
        return v;
 }

 if(!registry_key_exists(key:"SOFTWARE\Microsoft\Outlook Express")){
	exit(0);
 }

 if(hotfix_check_sp(win2k:5) > 0)
 {
        vers = get_version();
        if(vers == NULL){
                exit(0);
        }

	# Grep < 5.50.4990.2500
        if(ereg(pattern:"^5\.50\.4999\.([01]?[0-9]?[0-9]?[0-9]|2[0-4][0-9][0-9])$",
		string:vers))
	{
                security_warning(0);
                exit(0);
        }

	# Grep < 6.0.2800.1933
        if(ereg(pattern:"^6\.0?0\.2800\.(0?[0-9]?[0-9]?[0-9]|1([0-8][0-9][0-9]|" +
			"9[0-2][0-9]|93[0-2]))$", string:vers))
	{
		security_warning(0);
        	exit(0);
	}
 }

 if(hotfix_check_sp(xp:4) > 0)
 {
        vers = get_version();
        if(vers == NULL){
                exit(0);
        }

        SP = get_kb_item("SMB/WinXP/ServicePack");
	if("Service Pack 2" >< SP)
        {
		# Grep < 6.0.2900.3350
		if(ereg(pattern:"^6\.0?0\.2900\.([0-2]?[0-9]?[0-9]?[0-9]|3([0-2][0-9][0-9]|" +
                        	"3[0-4][0-9]))$", string:vers)){
                	security_warning(0);
		}
                exit(0);
        }

	if("Service Pack 3" >< SP)
        {
		# Grep < 6.0.2900.5579
                if(ereg(pattern:"^6\.0?0\.2900\.([0-4]?[0-9]?[0-9]?[0-9]|5([0-4][0-9][0-9]|" +
                                "5[0-6][0-9]|57[0-8]))$", string:vers)){
                        security_warning(0);
                }
                exit(0);
	}
	else security_warning(0);
 }

 if(hotfix_check_sp(win2003:3) > 0)
 {
        vers = get_version();
        if(vers == NULL){
                exit(0);
        }

	SP = get_kb_item("SMB/Win2003/ServicePack");
	if("Service Pack 1" >< SP)
        {
		# Grep < 6.0.3790.3168
		if(ereg(pattern:"^6\.0?0\.3790\.([0-2]?[0-9]?[0-9]?[0-9]|3(0[0-9][0-9]|" +
                                "1[0-5][0-9]|16[0-7]))$", string:vers)){
                        security_warning(0);
                }
                exit(0);
        }

	if("Service Pack 2" >< SP)
        {
		# Grep < 6.0.3790.4325
                if(ereg(pattern:"^6\.0?0\.3790\.([0-3]?[0-9]?[0-9]?[0-9]|4([0-2][0-9][0-9]|" +
                                "3[01][0-9]|32[0-4]))$", string:vers)){
                        security_warning(0);
                }
                exit(0);
        }
        else security_warning(0);
 }
