##############################################################################
#
#  Cumulative Security Update for Internet Explorer (953838)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/13
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0112
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900030);
 script_bugtraq_id(30610, 30611, 30612, 30613, 30614);
 script_cve_id("CVE-2008-2254", "CVE-2008-2255", "CVE-2008-2256",
	       "CVE-2008-2257", "CVE-2008-2258", "CVE-2008-2259");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Windows : Microsoft Bulletins");
 script_name("Cumulative Security Update for Internet Explorer (953838)");
 script_summary("Check for the vulnerable version of Internet Explorer");
 desc = "
 MS08-045

 Overview : This host is missing critical security update according to
 Microsoft Bulletin MS08-045.

 Vulnerability Insight :

        Multiple flaws are due to,
        - uninitialized memory in certain situations.
        - an object that has not been correctly initialized or that has been deleted.
        - the way it handles argument validation in print preview handling.

        Impact : Remote attackers could execute remote code on the vulnerable
        system to gain the same user rights as the logged-on user.

 Impact Level : System

 Affected Software/OS :
        MS Internet Explorer 5.01 & 6 on MS Windows 2000
	MS Internet Explorer 6 on MS Windows 2003 and XP
        MS Internet Explorer 7 on MS Windows 2003 and XP


 Fix : Run Windows Update and update the listed hotfixes or download and
 update mentioned hotfixes in the advisory from the below link.
 http://www.microsoft.com/technet/security/bulletin/ms08-045.mspx

 References : http://www.microsoft.com/technet/security/bulletin/ms08-045.mspx

 CVSS Score :
        CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.5
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_reg.inc");
 include("secpod_smb_func.inc");
 include("secpod_ie_supersede.inc");

 if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
        exit(0);
 }

 function get_version()
 {
        if(hotfix_missing(name:"953838") == 0){
                exit(0);
        }

	dllPath = registry_get_sz(item:"Install Path",
                  key:"SOFTWARE\Microsoft\COM3\Setup");

	dllPath += "\mshtml.dll";
	share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
        file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

        name    =  kb_smb_name();
        login   =  kb_smb_login();
        pass    =  kb_smb_password();
        domain  =  kb_smb_domain();
        port    =  kb_smb_transport();

        soc = open_sock_tcp(port);
        if(!soc){
                exit(0);
        }

        r = smb_session_request(soc:soc, remote:name);
        if(!r)
        {
                close(soc);
                exit(0);
        }

        prot = smb_neg_prot(soc:soc);
        if(!prot)
        {
                close(soc);
                exit(0);
        }

        r = smb_session_setup(soc:soc, login:login, password:pass,
                              domain:domain, prot:prot);
        if(!r)
        {
                close(soc);
                exit(0);
        }

        uid = session_extract_uid(reply:r);

        r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
        tid = tconx_extract_tid(reply:r);
        if(!tid)
        {
                close(soc);
                exit(0);
        }

        fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
        if(!fid)
        {
                close(soc);
                exit(0);
        }

        v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod", offset:2000000);
        return v;


 }

 ieVer = registry_get_sz(key:"SOFTWARE\Microsoft\Internet Explorer",
                         item:"Version");
 if(!ieVer){
     ieVer = registry_get_sz(item:"IE",
		      key:"SOFTWARE\Microsoft\Internet Explorer\Version Vector");
 }

 if(!ieVer){
	exit(0);
 }

 if(ie_latest_hotfix_update(bulletin:"MS08-045")){
   exit(0);
 }

 if(hotfix_check_sp(win2k:5) > 0)
 {
        vers = get_version();
        if(vers == NULL){
                exit(0);
        }

        # Check for IE version 5
        if(ereg(pattern:"^5\..*", string:ieVer))
        {
		# Grep < 5.0.3866.2000
                if(ereg(pattern:"^(5\.00\.(([0-2]?[0-9]?[0-9]?[0-9]|3?([0-7]?"+
                                "[0-9]?[0-9]|8?([0-5]?[0-9]|6[0-5])))(\..*)|"+
                                "3866\.[01]?[0-9]?[0-9]?[0-9]))$", string:vers)){
                        security_hole(0);
                }
                exit(0);
        }

        # Check for IE version 6
        if(ereg(pattern:"^6\..*", string:ieVer))
        {
		# Grep < 6.0.2800.1614
                if(ereg(pattern:"^(6\.00\.(([01]?[0-9]?[0-9]?[0-9]|2?([0-7]?["+
                                "0-9]?[0-9]))(\..*)|2800\.(0?[0-9]?[0-9]?[0-"+
                                "9]|1([0-5][0-9][0-9]|6(0[0-9]|1[0-3])))))$",
                        string:vers)){
                        security_hole(0);
                }
                exit(0);
        }
 }

 if(hotfix_check_sp(xp:4) > 0)
 {
        vers = get_version();
        if(vers == NULL){
                exit(0);
        }

	SP = get_kb_item("SMB/WinXP/ServicePack");
        # Check for IE version 6
        if(ereg(pattern:"^6\..*", string:ieVer))
        {
                if("Service Pack 2" >< SP)
                {
			# Grep < 6.0.2900.3395
			if(ereg(pattern:"^(6\.00\.(([01]?[0-9]?[0-9]?[0-9]|2?([0-8]?["+
                                "0-9]?[0-9]))(\..*)|2900\.([0-2]?[0-9]?[0-9]"+
                                "?[0-9]|3([0-2][0-9][0-9]|3([0-8][0-9]"+
                                "|9[0-4])))))$", string:vers)){
 				security_hole(0);
                	}
                	exit(0);
        	}
		if("Service Pack 3" >< SP)
		{
			# Grep < 6.0.2900.5626
			if(ereg(pattern:"^(6\.00\.(([01]?[0-9]?[0-9]?[0-9]|2?([0-8]?["+
                                "0-9]?[0-9]))(\..*)|2900\.([0-4]?[0-9]?[0-9]"+
                                "?[0-9]|5([0-5][0-9][0-9]|6([01][0-9]"+
                                "|2[0-5])))))$", string:vers)){
                                security_hole(0);
                        }
                        exit(0);
		}
		else security_hole(0);
	}

        # Check for IE version 7
        if(ereg(pattern:"^7\..*", string:ieVer))
        {
		# Grep < 7.0.6000.16705
                if(ereg(pattern:"^(7\.00\.([0-5]?[0-9]?[0-9]?[0-9]\..*|6000\."+
                                "(0?[0-9]?[0-9]?[0-9]?[0-9]|1([0-5][0-9]"+
                                "[0-9][0-9]|6([0-6][0-9][0-9]|70[0-4])))))$",
			string:vers)){
                        security_hole(0);
                }
                exit(0);
        }
 }

 if(hotfix_check_sp(win2003:3) > 0)
 {
        vers = get_version();
        if(vers == NULL){
                exit(0);
        }

	SP = get_kb_item("SMB/Win2003/ServicePack");
        # Check for IE version 6
        if(ereg(pattern:"^6\..*", string:ieVer))
        {
		if("Service Pack 1" >< SP)
                {
			# Grep < 6.0.3790.3167
			if(ereg(pattern:"(6\.00\.(([0-2]?[0-9]?[0-9]?[0-9]|3([0-6]"+
                                "[0-9][0-9]|7[0-8][0-9]))(\..*)|3790\.([0"+
                                "-2]?[0-9]?[0-9]?[0-9]|3(0[0-9][0-9]|1(["+
                                "0-5]?[0-9]|6?[0-6])))))$", string:vers)){
            			security_hole(0);
                	}
                	exit(0);
        	}

		if("Service Pack 2" >< SP)
		{
			# Grep < 6.0.3790.4324
                        if(ereg(pattern:"(6\.00\.(([0-2]?[0-9]?[0-9]?[0-9]|3([0-6]"+
                                "[0-9][0-9]|7[0-8][0-9]))(\..*)|3790\.([0"+
                                "-3]?[0-9]?[0-9]?[0-9]|4([0-2][0-9][0-9]|3(["+
                                "01]?[0-9]|2[0-3])))))$", string:vers)){
                                security_hole(0);
                        }
                        exit(0);
                }
		else security_hole(0);
	}

        #Check for IE version 7
        if(ereg(pattern:"^7\..*", string:ieVer))
        {
		# Grep < 7.0.6000.16705
                if(ereg(pattern:"(7\.00\.([0-5]?[0-9]?[0-9]?[0-9]\..*|6000\."+
                                "(0?[0-9]?[0-9]?[0-9]?[0-9]|1([0-5][0-9]"+
                                "[0-9][0-9]|6([0-6][0-9][0-9]|70[0-4])))))$",
			string:vers)){
                        security_hole(get_kb_item("SMB/transport"));
                }
                exit(0);
        }
 }
