###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mpg123_detect_lin.nasl 1787 2009-04-20 11:30:29Z apr $
#
# mpg123 Player Version Detection (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900543);
  script_version("$Revision: 1.0 $");
  script_name("mpg123 Player Version Detection (Linux)");
  desc = "
  Overview: This script detects the installed version of mpg123 Player
  and sets the reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of mpg123 Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();

if(!sock){
  exit(0);
}

paths = find_file(file_name:"mpg123",file_path:"/",
                  useregex:TRUE, regexpar:"$", sock:sock);
foreach binName (paths)
{
  mpgVer = get_bin_version(full_prog_name:binName, version_argv:"--version",
                                ver_pattern:"[0-9]\.[0-9]\.[0-9]+",
                                sock:sock);
  if(mpgVer[0] != NULL)
  {
    set_kb_item(name:"mpg123/Linux/Ver", value:mpgVer[0]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
