##############################################################################
#
#  MicroWorld MailScan for Mail Servers multiple vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/20
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0134
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900204);
 script_bugtraq_id(30700);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_MIXED_ATTACK);
 script_family("Web application abuses");
 script_name("MicroWorld MailScan for Mail Servers multiple vulnerabilities");
 script_summary("Check for MailScan version and XSS attack");
 desc = "
 Overview : This host is running MailScan a Mail Server, which is prone to
 multiple vulnerabilities.

 Vulnerability Insight :

        Multiple flaws are due to,
        - an input validation error within the web administration interface.
        - the web administration interface does not properly restrict access
          to certain pages. can cause an authentication-bypass vulnerability.
        - an input passed via URL to the web administration interface is not
          properly sanitized before being returned to the user.

        Impact : Successful Remote exploitation will allow, to gain unauthorized
        access to disclose sensitive information, directory traversal attacks,
        cross site scripting, execution fo arbitrary script code within the
        context of the website to steal cookie-based authentication credentials.

 Impact Level : Application

 Affected Software/OS :
        MicroWorld MailScan for Mail Servers 5.6a and prior versions.

 Fix : No solution/patch is available as on 21st August, 2008. Information
 regarding this issue will update once the solution details are available.
 For updates refer, http://www.mwti.net/

 References : http://secunia.com/advisories/31534
 http://www.oliverkarow.de/research/mailscan.txt

 CVSS Score :
        CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
        CVSS Temporal Score : 5.2 
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("http_func.inc");
 include("http_keepalive.inc");

 port = 10443;
 if(!port){
        exit(0);
 }

 sndReq = http_get(item:"/main.dll", port:port);
 rcvRes = http_keepalive_send_recv(port:port, data:sndReq);

 if("Welcome to MicroWorld's MailScan" >!< rcvRes){
        exit(0);
 }

 if(!safe_checks())
 {
	# Directory Traversal Request
        sndReq = http_get(item:"/../../../../boot.ini", port:port);
        rcvRes = http_keepalive_send_recv(port:port, data:sndReq);

        if("HTTP/1.1 200" >< rcvRes && "[boot loader]" >< rcvRes){
                security_warning(port);
        }
        exit(0);
 }

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 mailScanVer = registry_get_sz(key:"SOFTWARE\MicroWorld\C:#PROGRA~1#MAILSCAN" +
				   "#MAILSCAN.INI\General", item:"Version");
 if(!mailScanVer){
	exit(0);
 }

 # Grep for <= 5.6a
 if(egrep(pattern:"^([0-4]\..*|5\.[0-5][a-z]?|5\.6a?)$", string:mailScanVer)){
 	security_warning(port);
 }
