###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mediawiki_info_disc_vuln.nasl 737 2008-12-31 17:15:29Z dec $
#
# MediaWiki Information Disclosure Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900422);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5687", "CVE-2008-5688");
  script_name("MediaWiki Information Disclosure Vulnerabilities");
  desc = "

  Overview: This host is running MediaWiki and is prone to Information
  Disclosure Vulnerabilities.

  Vulnerability Insight:
  The flaws are due to,
  - wgShowExceptionDetails variable sometimes shows the installation path of
    MediaWiki which can lead to expose sensitive information about the remote
    system.
  - fails to protect against the download of backups of deleted images in
    images/deleted/.

  Impact:
  Successful exploitation will lead to gain knowledge on sensitive directories
  on the remote web server via requests.

  Affected Software/OS:
  MediaWiki version 1.8.1 to 1.13.3
  MediaWiki version 1.11 to 1.13.3

  Fix: No solution or patch is available as on 31st December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mediawiki.org/wiki/Download

  References:
  http://www.mediawiki.org/wiki/Manual:$wgShowExceptionDetails
  http://lists.wikimedia.org/pipermail/mediawiki-announce/2008-December/000080.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of MediaWiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_mediawiki_detect.nasl");
  script_require_keys("MediaWiki/Version");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!port){
  port = 80;
}

wikiVer = get_kb_item("MediaWiki/Version");
if(!wikiVer){
  exit(0);
}

if(version_in_range(version:wikiVer, test_version:"1.8.1", test_version2:"1.13.3")){
  security_warning(port);
}
