###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_marcelo_costa_fileserver_dir_trav_vuln.nasl 3577 2009-08-01 16:28:26Z jul $
#
# Marcelo Costa FileServer Component Directory Traversal Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900810);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2544");
  script_name("Marcelo Costa FileServer Component Directory Traversal Vulnerability");

  desc = "
  Overview:
  This host is running Marcelo Costa FileServer with Windows Live Messenger and
  Messenger Plus! Live, and is prone to directory traversal vulnerability.

  Vulnerability Insight:
  Error in the FileServer component which may allows remote authenticated users
  to list arbitrary directories and read arbitrary files via a .. (dot dot) in
  a pathname.

  Impact:
  Successful exploitation will let the attackers to cause Directory Traversal
  attacks on the affected product.

  Impact Level: System/Application

  Affected Software/OS:
  Marcelo Costa FileServer version 1.0

  Fix: No solution or patch is available as on 31st July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.msgpluslive.com/scripts/view/65-FileServer/

  References:
  http://www.milw0rm.com/exploits/9093
  http://en.securitylab.ru/nvd/382773.php

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:L/Au:SI/C:C/I:N/A:N)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Marcelo Costa FileServer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_ms_win_live_messenger_detect.nasl");
  script_require_keys("MS/MessengerPlus/Ver", "MS/MessengerPlus/Path");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

# Check for Messenger Plus! Live Installation
if(get_kb_item("MS/MessengerPlus/Ver") =~ "^4\..*")
{
  # Get for Installed Location of Messenger Plus! Live
  plusPath = get_kb_item("MS/MessengerPlus/Path");

  if(isnull(plusPath)){
    exit(0);
  }

  fsPath = NULL;
  if("\Uninstall.exe" >< plusPath)
    fsPath = plusPath - "\Uninstall.exe" + "\Scripts\FileServer\fsVersion.txt";
  else if("\MsgPlus.exe" >< plusPath)
    fsPath = plusPath - "\MsgPlus.exe" + "\Scripts\FileServer\fsVersion.txt";

  if(!isnull(fsPath))
  {
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:fsPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:fsPath);

    # Read the FileServer fsVersion.txt File
    fileSrvTxt = read_file(share:share, file:file, offset:0, count:100);

    if(isnull(fileSrvTxt)){
      exit(0);
    }
    # Grep for FileServer Version
    costaVer = egrep(pattern:"[0-9.]+", string:fileSrvTxt);

    # Check for FileServer Version
    if(costaVer && version_is_equal(version:costaVer, test_version:"1.0")){
      security_hole(0);
    }
  }
}
