###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mahara_info_disc_vuln.nasl 3100 2009-06-25 17:38:29Z jun $
#
# Mahara Information Disclosure Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900383);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2171");
  script_name("Mahara Information Disclosure Vulnerability");
  desc = "

  Overview: This host is running Mahara and is prone to Information Disclosure
  Vulnerability.

  Vulnerability Insight:
  - The application fails to apply permission checks when saving a view that 
    contains artefacts, which allows remote authenticated users to read
    another user's artefact.

  Impact:
  Successful exploitation will let the attacker to gain sensitive information
  in the affected web application.

  Impact Level: Application

  Affected Software/OS:
  Mahara version 1.1 before 1.1.5

  Fix: Upgrade to Mahara version 1.1.5 or later
  https://eduforge.org/projects/mahara/

  References:
  http://mahara.org/interaction/forum/topic.php?id=753

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:N/AC:L/Au:SI/C:P/I:N/A:N)
    CVSS Temporal Score : 3.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Mahara");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_mahara_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

maharaPort = get_http_port(default:80);
if(!maharaPort){
  exit(0);
}

maharaVer = get_kb_item("www/"+ maharaPort + "/Mahara");
if(!maharaVer){
  exit(0);
}

ver = eregmatch(pattern:"^(.+) under (/.*)$", string:maharaVer);
if(ver[1] != NULL)
{
  # Check for Mahara version 1.1 < 1.1.5
  if(version_in_range(version:ver[1], test_version:"1.1",
                                      test_version2:"1.1.4")){
    security_warning(maharaPort);
  }
}
