###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_libpng_null_pntr_vuln.nasl 851 2009-01-20 17:26:15 jan $
#
# libpng pngwutil.c NULL pointer Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900071);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5907");
  script_name("libpng pngwutil.c NULL pointer Vulnerability");
  desc = "

  Overview: The host has libpng installed and is prone to memory overwrite
  vulnerability.

  Vulnerability Insight:
  Attackers can set the value of arbitrary memory location to zero via
  vectors involving creation of crafted PNG files with keywords, related
  to an implicit cast of the '\0' character constant to a NULL pointer.

  Impact:
  Successful remote exploitation could result in arbitrary code execution
  on the affected system.

  Impact Level: Application

  Affected Software/OS:
  libpng 1.0.41 and prior and 1.2.x to 1.2.33 on Linux.

  Fix: Upgrade to libpng 1.0.42 or 1.2.34,
  http://libpng.sourceforge.net/index.html

  References:
  http://openwall.com/lists/oss-security/2009/01/09/1

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 4.1
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of libpng");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_libpng_detect_lin.nasl");
  script_require_keys("Libpng/Version");
  exit(0);
}


include("version_func.inc");

pngVer = get_kb_item("Libpng/Version");
if(!pngVer){
  exit(0);
}

if(version_is_less_equal(version:pngVer, test_version:"1.0.41")||
   version_in_range(version:pngVer, test_version:"1.2.0", test_version2:"1.2.33")){
  security_warning(0);
}
