###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_kvirc_arg_inj_vuln_win.nasl 4293 2009-08-28 13:24:24Z aug $
#
# KVIrc URI Handler Argument Injection Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901011);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7070");
  script_bugtraq_id(32410);
  script_name("KVIrc URI Handler Argument Injection Vulnerability");
  desc = "
  Overview: This host has KVIrc installed and is prone to Argument Injection
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an improper validation of user supplied input, which
  can be exploited by persuading a victim to open a specially-crafted 'irc:///',
  'irc6:///', 'ircs:///', or 'ircs6:///' URI.

  Impact:
  Successful exploitation will let the attackers to execute arbitrary commands.

  Impact Level: Application

  Affected Software/OS:
  KVirc version 3.4.2 and prior on Windows

  Fix: No solution or patch is available as on 28th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.kvirc.net/?lang=en

  References:
  http://www.milw0rm.com/exploits/7181
  http://xforce.iss.net/xforce/xfdb/46779

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of KVIrc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_kvirc_detect_win.nasl");
  script_require_keys("Kvirc/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Get for KVIrc Version
kvircVer = get_kb_item("Kvirc/Win/Ver");

if(kvircVer != NULL)
{
  # Check for KVirc version <= 3.4.2
  if(version_is_less_equal(version:kvircVer, test_version:"3.4.2")){
    security_hole(0);
  }
}
