###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_jag_info_disc_vuln.nasl 7361 2010-02-24 11:43:17Z feb $
#
# JAG (Just Another Guestbook) Information Disclosure Vulnerability
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900745);
  script_version("$Revision: 6841 $: 1.0");
  script_cve_id("CVE-2010-0665");
  script_name("JAG (Just Another Guestbook) Information Disclosure Vulnerability");
  desc = "
  Overview: The host is running JAG and is prone to Information Disclosure
  vulnerability.

  Vulnerability Insight:
  The flaw is caused by improper restrictions on the 'database.sql file'. By
  sending a direct request, this can exploited to download the backup database.

  Impact:
  Successful exploitation will allow remote attackers to download the backup
  database and obtain sensitive information.

  Impact Level: Application

  Affected Software/OS:
  JAG (Just Another Guestbook) version 1.14 and prior.

  Fix: No solution or patch is available as on 24th February, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.xs4all.nl/~crisp/jag/index.html

  References:
  http://xforce.iss.net/xforce/xfdb/56228
  http://www.exploit-db.com/exploits/11406

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 4.5
  Risk factor : Medium";

  script_description(desc);
  script_copyright("Copyright (C) 2010 SecPod");
  script_summary("Check through the attack string and version of JAG");
  script_category(ACT_MIXED_ATTACK);
  script_family("Web application abuses");
  script_dependencies("secpod_jag_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

jagPort = get_http_port(default:80);
if(!jagPort){
  exit(0);
}

jagVer = get_kb_item("www/" + jagPort + "/JAG");
if(isnull(jagVer)){
  exit(0);
}

jagVer = eregmatch(pattern:"^(.+) under (/.*)$", string:jagVer);
if(!safe_checks() && jagVer[2] != NULL)
{
  sndReq = http_get(item:string(jagVer[2], "/database.sql"), port:jagPort);
  rcvRes = http_send_recv(port:jagPort, data:sndReq);
  if(!isnull(rcvRes) && ("create table guestbook" >< rcvRes))
  {
    security_warning(jagPort);
    exit(0);
  }
}

if(jagVer[1] != NULL)
{
  if(version_is_less_equal(version:jagVer[1], test_version:"1.14")){
    security_warning(jagPort);
  }
}
