###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_irfanview_detect.nasl 3004 2009-06-19 14:45:29Z jun $
#
# IrfanView Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900376);
  script_version("$Revision: 1.0 $");
  script_name("IrfanView Version Detection");
  desc = "
  Overview: This script detects the installed version of IrfanView and
  sets the reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of IrfanView");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!(registry_key_exists(key:"SOFTWARE\Classes\IrfanView32\shell\open\command")||
     registry_key_exists(key:"SOFTWARE\Classes\IrfanView\shell\open\command"))){
  exit(0);
}

path = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                       item:"ProgramFilesDir");
if(path != NULL)
{
  irViewPath = path + "\IrfanView\i_view32.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:irViewPath);
  irView = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:irViewPath);

  soc = open_sock_tcp(port);
  if(!soc){
    exit(0);
  }

  r = smb_session_request(soc:soc, remote:name);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  prot = smb_neg_prot(soc:soc);
  if(!prot)
  {
    close(soc);
    exit(0);
  }

  r = smb_session_setup(soc:soc, login:login, password:pass,
                        domain:domain, prot:prot);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  uid = session_extract_uid(reply:r);
  r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  tid = tconx_extract_tid(reply:r);
  if(!tid)
  {
    close(soc);
    exit(0);
  }

  fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:irView);
  if(!fid)
  {
    close(soc);
    exit(0);
  }

  irViewVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod");
  close(soc);
}

if(irViewVer != NULL){
  set_kb_item(name:"IrfanView/Ver", value:irViewVer);
}
