##############################################################################
#
#  IBM TSM Client Remote Heap BOF Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/31
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0418
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900169);
  script_bugtraq_id(31988);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("Buffer overflow");
  script_name("IBM TSM Client Remote Heap BOF Vulnerability");
  script_summary("Check for vulnerable version of IBM TSM Client");
  desc = "
  Overview: This host is installed with IBM TSM Client and is prone to heap
  based buffer overflow vulnerability.

  Vulnerability exists due to an input validation error in TSM Backup-Archive
  client, which affects the Client Acceptor Daemon (CAD) and the Backup-Archive
  client scheduler and scheduler service when the option 'SCHEDMODE' is set
  to 'PROMPTED'.
  
  Impact:
  Successful exploitation could allow execution of arbitrary code or cause
  denial of service. 

  Impact Level: Application

  Affected Software/OS:
  - IBM Tivoli Storage Manager (TSM) versions 5.5.0.0 through 5.5.0.7
  - IBM Tivoli Storage Manager (TSM) versions 5.4.0.0 through 5.4.2.2
  - IBM Tivoli Storage Manager (TSM) versions 5.3.0.0 through 5.3.6.1
  - IBM Tivoli Storage Manager (TSM) versions 5.2.0.0 through 5.2.5.2
  - IBM Tivoli Storage Manager (TSM) versions 5.1.0.0 through 5.1.8.1
  - IBM Tivoli Storage Manager (TSM) Express all levels

  Fix: Apply patch
  http://www-01.ibm.com/support/docview.wss?uid=swg21322623

  References:
  http://secunia.com/advisories/32465/
  http://www.zerodayinitiative.com/advisories/ZDI-08-071/

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\IBM\ADSM\CurrentVersion\Api";
pkgName = registry_get_sz(key:key, item:"Path");

if("Tivoli\TSM" >!< pkgName){
  exit(0);
}

tsmVer = registry_get_sz(key:key, item:"PtfLevel");
if(tsmVer){
  # Grep the versions <= 5.1.8.1, <= 5.2.5.2, <= 5.3.6.1, <= 5.4.2.2, <= 5.5.0.7
  if(egrep(pattern:"^(5\.(1\.([0-7]\..*|8\.[01])|2\.([0-4]\..*|5\.[0-2])|3\." +
                   "([0-5]\..*|6\.[01])|4\.([01]\..*|2\.[0-2])|5\.(0\.[0-7])))$",
           string:tsmVer)){
    security_hole(0);
  }
}
