###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ibm_lotus_notes_html_inj_vuln_lin.nasl 4611 2009-09-11 13:24:24Z sep $
#
# IBM Lotus Notes RSS Reader Widget HTML Injection Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901015);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3114");
  script_bugtraq_id(36305);
  script_name("IBM Lotus Notes RSS Reader Widget HTML Injection Vulnerability (Linux)");
  desc = "
  Overview: This host has IBM Lotus Notes installed and is prone to HTML
  Injection vulnerability.

  Vulnerability Insight:
  The flaw is due to error in the RSS reader widget, caused when items are
  saved from an RSS feed as local HTML documents. This can be exploited via a
  crafted feed.

  Impact:
  Successful exploitation will let the attackers to inject HTML based code.

  Impact Level: Application

  Affected Software/OS:
  IBM Lotus Notes Version 8.5 on Linux.

  Fix: No solution or patch is available as on 11th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.ibm.com/software/lotus/products/notes/

  References:
  http://www.scip.ch/?vuldb.4021
  http://www.securityfocus.com/archive/1/archive/1/506296/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of IBM Lotus Notes");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_ibm_lotus_notes_detect_lin.nasl");
  script_require_keys("IBM/LotusNotes/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Get for IBM Lotus Notes Version
lotusVer = get_kb_item("IBM/LotusNotes/Linux/Ver");

if(lotusVer != NULL)
{
  # Check for KVirc version 8.5 <= 8.5.00.8318
  if(version_in_range(version:lotusVer, test_version:"8.5",
                                       test_version2:"8.5.00.8318")){
    security_hole(0);
  }
}
