##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ibm_lotus_notes_detect_win.nasl 4611 2009-09-11 14:30:24Z sep $
#
# IBM Lotus Notes Version Detection (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901013);
  script_version("$Revision: 1.0 $");
  script_name("IBM Lotus Notes Version Detection (Win)");
  desc = "
  Overview: This script detects the installed version of IBM Lotus Notes and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set Version of IBM Lotus Notes in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

# Check for Windows
if(!get_kb_item("SMB/WindowsVersion"))
{
  exit(0);
}

# Check for Lotus Notes Existance
if(!registry_key_exists(key:"SOFTWARE\IBM\Lotus\Expeditor\Notes")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  notesName = registry_get_sz(key:key + item, item:"DisplayName");

  if("Lotus Notes" >< notesName)
  {
    lotusVer = registry_get_sz(key:key + item, item:"DisplayVersion");

    # Set KB for Lotus Notes
    if(lotusVer != NULL){
      set_kb_item(name:"IBM/LotusNotes/Win/Ver", value:lotusVer);
    }
  }
}
