###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ibm_db2_mult_vuln_win.nasl 4140 2009-08-20 15:11:27Z aug $
#
# IBM DB2 Multiple Vulnerabilities (Win)
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(101106);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2859", "CVE-2009-2860");
  script_name("IBM DB2 Multiple Vulnerabilities (Win)");
  desc = "

  Overview: The host is installed with IBM DB2 and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  The flaws is caused due to:
  - An unspecified error when using DAS command may allow attackers to gain
    unauthorized access to a vulnerable database.
  - An unspecified error when processing malformed packets can be exploited
    to cause DB2JDS to crash creating a denial of service condition.

  Impact:
  Successful exploitation will let the attacker to cause a denial of service or
  compromise a vulnerable system.

  Impact Level: System/Application

  Affected Software/OS:
  IBM DB2 version 8.1 prior to Fixpak 18

  Fix: Update IBM DB2 Version 8.1 Fixpak 18,
  For Updates refer, http://www-01.ibm.com/support/docview.wss?uid=swg24024075

  References:
  http://secunia.com/advisories/36313
  http://www.vupen.com/english/advisories/2009/2293
  ftp://ftp.software.ibm.com/ps/products/db2/fixes/english-us/aparlist/db2_v82/APARLIST.TXT

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of IBM DB2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_ibm_db2_detect_win_900218.nasl");
  script_require_keys("Win/IBM-db2/Ver");
  exit(0);
}


include("version_func.inc");

ibmVer = get_kb_item("Win/IBM-db2/Ver");
if(!ibmVer){
  exit(0);
}

# Check for IBM DB2 Version 8.1 before 8.1 FP18 (8.1.18)
if(version_in_range(version:ibmVer, test_version:"8.1",test_version2:"8.1.17")){
  security_hole(0);
}
