##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_hyleos_chemview_detect.nasl 7392 2010-02-26 13:10:24Z feb $
#
# Hyleos ChemView Version Detection
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http//www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900748);
  script_version("$Revision: 6868 $: 1.0");
  script_name("Hyleos ChemView Version Detection");
  desc = "
  Overview: This script finds the installed Hyleos ChemView and saves the
  version in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set version of Hyleos ChemView in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
      exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  name = registry_get_sz(key:key + item, item:"DisplayName");
  if("Hyleos - ChemViewX" >< name)
  {
    chemVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(chemVer != NULL){
       set_kb_item(name:"Hyleos/ChemViewX/Ver", value:chemVer);
    }
  }
}
