###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_mult_vuln_jul09.nasl 3595 2009-07-23 10:48:29Z jul $
#
# Google Chrome Multiple Vulnerabilities - Jul09
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900695);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-2555", "CVE-2009-2556");
  script_bugtraq_id(35722, 35723);
  script_name("Google Chrome Multiple Vulnerabilities - Jul09");
  desc = "

  Overview: This host has Google Chrome installed and is prone to Multiple
  vulnerabilities.

  Vulnerability Insight:
  The multiple flaws are due to,
  - Heap overflow error when evaluating a specially crafted regular expression
    in Javascript within sandbox.
  - Error while allocating memory buffers for a renderer (tab) process.

  Impact:
  Successful exploitation will let the remote attackers to execute arbitrary
  code with the  privileges of the logged on user by bypassing the sandbox
  and may crash the browser.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version prior to 2.0.172.37


  Fix:
  Upgrade to Google Chrome version 2.0.172.37
  For updates refer, http://www.google.com/chrome

  References:
  http://secunia.com/advisories/35844
  http://xforce.iss.net/xforce/xfdb/51801
  http://www.vupen.com/english/advisories/2009/1924

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(chromeVer != NULL)
{
  # Check for Google Chrome version < 2.0.172.37
  if(version_is_less(version:chromeVer, test_version:"2.0.172.37")){
    security_hole(0);
  }
}
