###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_mult_vuln_aug09.nasl 4347 2009-08-28 12:52:29Z aug $
#
# Google Chrome 'JavaScript' And 'HTTPS' Multiple Vulnerabilities - Aug09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900832);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2935", "CVE-2009-2973");
  script_bugtraq_id(36149);
  script_name("Google Chrome 'JavaScript' And 'HTTPS' Multiple Vulnerabilities - Aug09");
  desc = "
  Overview: This host is installed with Google Chrome and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - When 'Google V8' is used in the application, it allows to bypass intended
    restrictions on reading memory, and possibly obtain sensitive information
    in the Chrome sandbox, via crafted JavaScript.
  - Application fails to prevent SSL connections to a site with an X.509
    certificate signed with the MD2 or MD4 algorithm, which makes it easier for
    man-in-the-middle attackers to spoof arbitrary HTTPS servers via a crafted
    certificate.

  Impact:
  Successful exploitation will let the attacker to spoof the X.509 certificate.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version prior to 2.0.172.43 on Windows.

  Fix: Upgrade to version 2.0.172.43 or later
  http://www.google.com/chrome

  References:
  http://secunia.com/advisories/36417
  http://www.vupen.com/english/advisories/2009/2420
  http://googlechromereleases.blogspot.com/2009/08/stable-update-security-fixes.html

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Get for Chrome Version
chromeVer = get_kb_item("GoogleChrome/Win/Ver");

if(isnull(chromeVer)){
  exit(0);
}

# Check for Google Chrome version < 2.0.172.43
if(version_is_less(version:chromeVer, test_version:"2.0.172.43")){
  security_warning(0);
  exit(0);
}
